#include "stdafx.h"

#ifdef VCLINK_STATIC
	#define hInstVCTRAN32 theApp.GetVCTRAN32()
#else
	#include "VCType32.h"
	#include "VCTran32.h"
	extern HMODULE hInstVCTRAN32;
#endif

//============== VCAcadBlockRead ==============
typedef void (CALLBACK* VCAcadBlockReadFN) (char*);

void WINAPI VCAcadBlockRead (char* pName)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCAcadBlockRead");
	if (fp)
	{
		((VCAcadBlockReadFN)fp)(pName);
	}
}

//============== VCAcadRead ==============
typedef void (CALLBACK* VCAcadReadFN) (char*);

void WINAPI VCAcadRead (char* pN)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCAcadRead");
	if (fp)
	{
		((VCAcadReadFN)fp)(pN);
	}
}

//============== VCAcadReadNoPaint ==============
typedef void (CALLBACK* VCAcadReadNoPaintFN) (char*);

void WINAPI VCAcadReadNoPaint (char* pNameStart)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCAcadReadNoPaint");
	if (fp)
	{
		((VCAcadReadNoPaintFN)fp)(pNameStart);
	}
}

//============== VCAcadReadWith3D ==============
typedef void (CALLBACK* VCAcadReadWith3DFN) (char*);

void WINAPI VCAcadReadWith3D (char* pName)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCAcadReadWith3D");
	if (fp)
	{
		((VCAcadReadWith3DFN)fp)(pName);
	}
}

//============== VCAcadWriteDWG ==============
typedef void (CALLBACK* VCAcadWriteDWGFN) (char*);

void WINAPI VCAcadWriteDWG (char* pN)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCAcadWriteDWG");
	if (fp)
	{
		((VCAcadWriteDWGFN)fp)(pN);
	}
}

//============== VCAcadWriteDXF ==============
typedef void (CALLBACK* VCAcadWriteDXFFN) (char*);

void WINAPI VCAcadWriteDXF (char* pN)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCAcadWriteDXF");
	if (fp)
	{
		((VCAcadWriteDXFFN)fp)(pN);
	}
}

//============== VCLoadDrawing ==============
typedef void (CALLBACK* VCLoadDrawingFN) (short*, char*, short);

void WINAPI VCLoadDrawing (short* iError, char* pName, short iFileType)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCLoadDrawing");
	if (fp)
	{
		((VCLoadDrawingFN)fp)(iError, pName, iFileType);
	}
}

//============== VCMergeDrawing ==============
typedef void (CALLBACK* VCMergeDrawingFN) (short*, char*, short);

void WINAPI VCMergeDrawing (short* iError, char* pName, short iFileType)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCMergeDrawing");
	if (fp)
	{
		((VCMergeDrawingFN)fp)(iError, pName, iFileType);
	}
}

//============== VCMergeDrawingNoPaint ==============
typedef void (CALLBACK* VCMergeDrawingNoPaintFN) (short*, char*, short);

void WINAPI VCMergeDrawingNoPaint (short* iError, char* pInputName, short iFileType)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCMergeDrawingNoPaint");
	if (fp)
	{
		((VCMergeDrawingNoPaintFN)fp)(iError, pInputName, iFileType);
	}
}

//============== VCSaveDrawing ==============
typedef void (CALLBACK* VCSaveDrawingFN) (short*, char*, short, vbool);

void WINAPI VCSaveDrawing (short* iError, char* pName, short iFileType, vbool tfSaveSelected)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCSaveDrawing");
	if (fp)
	{
		((VCSaveDrawingFN)fp)(iError, pName, iFileType, tfSaveSelected);
	}
}

//============== VCWriteMetafile ==============
typedef void (CALLBACK* VCWriteMetafileFN) (char*, short, vbool);

void WINAPI VCWriteMetafile (char* pName, short iFileType, vbool tfSelectedOnly)
{
	FARPROC fp = GetProcAddress(hInstVCTRAN32 , (LPSTR)"VCWriteMetafile");
	if (fp)
	{
		((VCWriteMetafileFN)fp)(pName, iFileType, tfSelectedOnly);
	}
}

